-- Macro_Scripts File
-- Purpose:  define action for each creatable AEC Primitive objects to hook up to the create main menu (or quads)

/*
Revision History

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
--Doors
macroScript PivotDoor 
category:~PIVOTDOOR_CATEGORY~
internalCategory:"Objects AEC" 
tooltip:~PIVOTDOOR_TOOLTIP~ 
buttontext:~PIVOTDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",1)
(
StartObjectCreation pivot 
)

macroScript BifoldDoor
category:~BIFOLDDOOR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~BIFOLDDOOR_TOOLTIP~ 
buttontext:~BIFOLDDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",2)
(
StartObjectCreation BiFold
)

macroScript SlidingDoor 
category:~SLIDINGDOOR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGDOOR_TOOLTIP~
buttontext:~SLIDINGDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",3)
(
StartObjectCreation SlidingDoor
)


----------------------------------------------------------------------------------------------------
--Windows
macroScript AwningWindow 
category:~AWNINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~AWNINGWINDOW_TOOLTIP~
buttontext:~AWNINGWINDOW_BUTTONTEXT~
icon:#("ObjectsAEC_Win",1)
(
StartObjectCreation Awning 
)

macroScript FixedWindow 
category:~FIXEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FIXEDWINDOW_TOOLTIP~ 
buttontext:~FIXEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",3)
(
StartObjectCreation Fixed
)

macroScript ProjectedWindow
category:~PROJECTEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~PROJECTEDWINDOW_TOOLTIP~ 
buttontext:~PROJECTEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",5)
(
StartObjectCreation projected
)

macroScript CasementWindow 
category:~CASEMENTWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENTWINDOW_TOOLTIP~ 
buttontext:~CASEMENTWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",2)
(
StartObjectCreation Casement
)

macroScript PivotedWindow 
category:~CASEMENT_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENT_TOOLTIP~ 
buttontext:~CASEMENT_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",4)
(
StartObjectCreation Pivoted
)

macroScript SlidingWindow 
category:~SLIDINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGWINDOW_TOOLTIP~ 
buttontext:~SLIDINGWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",6)
(
StartObjectCreation SlidingWindow 
)



----------------------------------------------------------------------------------------------------
--Foliage
macroScript Foliage 
category:~FOLIAGE_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FOLIAGE_TOOLTIP~ 
buttontext:~FOLIAGE_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",1)
(
cui.CommandPanelOpen = true
StartObjectCreation Foliage
)



----------------------------------------------------------------------------------------------------
--Railing
macroScript Railing 
category:~RAILING_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~RAILING_TOOLTIP~ 
buttontext:~RAILING_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",2)
(
StartObjectCreation Railing
)



----------------------------------------------------------------------------------------------------
--Stairs
macroScript SpiralStair 
category:~SPIRALSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SPIRALSTAIR_TOOLTIP~ 
buttontext:~SPIRALSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",4)
(
StartObjectCreation Spiral_Stair
)

macroScript L_Stair 
category:~L_STAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~L_STAIR_TOOLTIP~ 
buttontext:~L_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",1)
(
StartObjectCreation L_Type_Stair
)

macroScript StraightStair 
category:~STRAIGHTSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~STRAIGHTSTAIR_TOOLTIP~ 
buttontext:~STRAIGHTSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",3)
(
StartObjectCreation Straight_Stair
)

macroScript U_Stair 
category:~U_STAIR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~U_STAIR_TOOLTIP~ 
buttontext:~U_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",2)
(
StartObjectCreation U_Type_Stair
)



----------------------------------------------------------------------------------------------------
--Wall
macroScript Wall 
category:~WALL_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~WALL_TOOLTIP~
buttontext:~WALL_BUTTONTEXT~
icon:#("ObjectsAEC_misc",3)
(
StartObjectCreation Wall
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBlMDd3YG5He0TiJVOrO3E36qCQYVH2nMln
-- +xN9irls6/JMdnOhAcLKbYgt9C2PH8ZuT8e066JgqOoziGhSztzyIvEnVkUlxiTq
-- XZKNAC3VisOj9ZK/l6RpPyvIpDo4jWU0KDLqGPEDCg3DnUATzfNePbIGyUv1Z4Vz
-- 1I5zAvB9NYcbaQ9fB+mTofGVneD8pfkT+MXHuOquhsnOk0hs12ZLARBfVQG9qwzG
-- RLqjPhd1kXoH2bTuzLyydG6i39BeQS9kXdYshwI2nSw8j0SghkJSY7KezE0l4QjC
-- ZRJj8jF7pgruammqJy24zOclWE0NS6RpQ+PZ9j+yJN65IT9+z8kr
-- -----END-SIGNATURE-----